/* Computao Grfica - Trabalho Final usando Glut
   Alunos : Dennis Kerr Coelho        9823209-6
            Thiago Henrique da Silva  9823257-6
	    Roberto De Olveira Leo   9823208-8
*/

/* ============ Bibliotecas e Definies ============ */
#include <stdio.h>
#include <stdlib.h>
#include <GL\glut.h>
#include <math.h>
#define FALSE 0
#define TRUE 1
#define ESC 27

void desenhaParalelepipedo(float x, float y, float z, float lar, float alt, float prof)
{
  lar = lar/2;
  alt = alt/2;
  prof = prof/2;
  glBegin(GL_QUADS);
    // cima
    glVertex3f( x + lar, y + alt, z + prof);
    glVertex3f( x + lar, y + alt, z - prof);
    glVertex3f( x - lar, y + alt, z - prof);
    glVertex3f( x - lar, y + alt, z + prof);
    // baixo
    glVertex3f( x + lar, y - alt, z + prof);
    glVertex3f( x + lar, y - alt, z - prof);
    glVertex3f( x - lar, y - alt, z - prof);
    glVertex3f( x - lar, y - alt, z + prof);
    // Frente
    glVertex3f( x + lar, y + alt, z + prof);
    glVertex3f( x - lar, y + alt, z + prof);
    glVertex3f( x - lar, y - alt, z + prof);
    glVertex3f( x + lar, y - alt, z + prof);
    // Trs
    glVertex3f( x + lar, y + alt, z - prof);
    glVertex3f( x - lar, y + alt, z - prof);
    glVertex3f( x - lar, y - alt, z - prof);
    glVertex3f( x + lar, y - alt, z - prof);
    // Esquerda
    glVertex3f( x + lar, y + alt, z + prof);
    glVertex3f( x + lar, y - alt, z + prof);
    glVertex3f( x + lar, y - alt, z - prof);
    glVertex3f( x + lar, y + alt, z - prof);
    // Direita
    glVertex3f( x - lar, y + alt, z + prof);
    glVertex3f( x - lar, y - alt, z + prof);
    glVertex3f( x - lar, y - alt, z - prof);
    glVertex3f( x - lar, y + alt, z - prof);
  glEnd();
};

class PESSOA
{
  private:
    float centroX,centroY,centroZ;
  public:
    PESSOA();
    mostraPessoa();
};
PESSOA::PESSOA()
{
  centroX = centroY = centroZ = 0;
};
PESSOA::mostraPessoa()
{
  glRotatef(15,0.0f,1.0f,0.0f);

  glTranslatef( 0.0, 0.0, -10.0);
  glColor3f ( 0.45, 0.1, 0.1);
  glBegin(GL_QUADS);


    //Teto e Chao
    glColor3f ( 0.1, 0.7, 0.1);
    desenhaParalelepipedo(centroX, centroY-2.2, centroZ, 100, 0.1, 100);
    glColor3f ( 0.6, 0.0, 0.0);
    desenhaParalelepipedo(centroX, centroY+10, centroZ, 100, 0.1, 100);
   // Paredes Laterais
    glColor3f ( 0.1, 0.4, 0.4);
    desenhaParalelepipedo(centroX, centroY+5, centroZ+50, 99.8, 14.2, 0.1);
    desenhaParalelepipedo(centroX, centroY+5, centroZ-50, 99.8, 14.2, 0.1);
    glColor3f ( 0.4, 0.1, 0.1);
    desenhaParalelepipedo(centroX+50, centroY+5, centroZ, 0.1, 14.2, 99.8);
    desenhaParalelepipedo(centroX-50, centroY+5, centroZ, 0.1, 14.2, 99.8);


    // Bola
    glColor3f ( 0.7, 0.7, 0.7);
    desenhaParalelepipedo(centroX-4, centroY-1.5, centroZ+3, 0.4, 0.4, 0.4);

    // Trave 1
    glColor3f ( 1, 1, 1);
    desenhaParalelepipedo(centroX - 10 , centroY, centroZ+49.7, 0.1, 4.2, 0.2);
    desenhaParalelepipedo(centroX + 10 , centroY, centroZ+49.7, 0.1, 4.2, 0.2);
    desenhaParalelepipedo(centroX, centroY+2, centroZ+49.8, 20, 0.3, 0.2);
    // Trave 2
    glColor3f ( 1, 1, 1);
    desenhaParalelepipedo(centroX - 10 , centroY, centroZ-49.7, 0.1, 4.2, 0.2);
    desenhaParalelepipedo(centroX + 10 , centroY, centroZ-49.7, 0.1, 4.2, 0.2);
    desenhaParalelepipedo(centroX, centroY+2, centroZ-49.8, 20, 0.3, 0.2);
    //Area Do Goleiro
    desenhaParalelepipedo(centroX - 15 , centroY-2, centroZ-39.8, 0.1, 0.1, 20);
    desenhaParalelepipedo(centroX + 15 , centroY-2, centroZ-39.8, 0.1, 0.1, 20);
    desenhaParalelepipedo(centroX, centroY-2, centroZ-29.8, 30, 0.1, 0.1);

    //Area Do Goleiro
    desenhaParalelepipedo(centroX - 15 , centroY-2, centroZ+39.8, 0.1, 0.1, 20);
    desenhaParalelepipedo(centroX + 15 , centroY-2, centroZ+39.8, 0.1, 0.1, 20);
    desenhaParalelepipedo(centroX, centroY-2, centroZ+29.8, 30, 0.1, 0.1);

    // Demarcacao do Campo
    glColor3f ( 1, 1, 1);
    desenhaParalelepipedo(centroX , centroY-2, centroZ, 99.8, 0.2, 0.2);
    desenhaParalelepipedo(centroX-50 , centroY-2, centroZ, 0.3, 0.3, 100);
    desenhaParalelepipedo(centroX+50 , centroY-2, centroZ, 0.3, 0.3, 100);
    desenhaParalelepipedo(centroX , centroY-2, centroZ+50, 100, 0.3, 0.3);
    desenhaParalelepipedo(centroX , centroY-2, centroZ-50, 100, 0.3, 0.3);

    // Boneco 1 Time 1
    glColor3f ( 1, 1, 0);
    // Cabeca
    desenhaParalelepipedo(centroX, centroY+1.2, centroZ, 0.6, 0.6, 0.6);
    //Pescoo
    desenhaParalelepipedo(centroX, centroY+0.8, centroZ, 0.3, 0.3, 0.3);
    //Peito
    desenhaParalelepipedo(centroX, centroY, centroZ, 1, 1.6, 0.6);
    //Brao Direito
    desenhaParalelepipedo(centroX+0.5, centroY+0.6, centroZ, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX+0.7, centroY+0.2, centroZ, 0.2, 1, 0.2);
    //Brao Esquerdo
    desenhaParalelepipedo(centroX-0.5, centroY+0.6, centroZ, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX-0.7, centroY+0.2, centroZ, 0.2, 1, 0.2);
    //Perna Direita
    desenhaParalelepipedo(centroX-0.3, centroY-1.2, centroZ, 0.4,0.8, 0.4);
    //Perna Esquerda
    desenhaParalelepipedo(centroX+0.3, centroY-1.2, centroZ, 0.4, 0.8, 0.4);

    // Boneco 2 Time 1
      glColor3f ( 1, 1, 0);
    // Cabeca
    desenhaParalelepipedo(centroX+10, centroY+1.2, centroZ-10, 0.6, 0.6, 0.6);
    //Pescoo
    desenhaParalelepipedo(centroX+10, centroY+0.8, centroZ-10, 0.3, 0.3, 0.3);
    //Peito
    desenhaParalelepipedo(centroX+10, centroY, centroZ-10, 1, 1.6, 0.6);
    //Brao Direito
    desenhaParalelepipedo(centroX+0.5+10, centroY+0.6, centroZ-10, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX+0.7+10, centroY+0.2, centroZ-10, 0.2, 1, 0.2);
    //Brao Esquerdo
    desenhaParalelepipedo(centroX-0.5+10, centroY+0.6, centroZ-10, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX-0.7+10, centroY+0.2, centroZ-10, 0.2, 1, 0.2);
    //Perna Direita
    desenhaParalelepipedo(centroX-0.3+10, centroY-1.2, centroZ-10, 0.4,0.8, 0.4);
    //Perna Esquerda
    desenhaParalelepipedo(centroX+0.3+10, centroY-1.2, centroZ-10, 0.4, 0.8, 0.4);

    // Boneco 3 Time 1
     glColor3f ( 0, 0, 1);
    // Cabeca
    desenhaParalelepipedo(centroX, centroY+1.2, centroZ+40, 0.6, 0.6, 0.6);
    //Pescoo
    desenhaParalelepipedo(centroX, centroY+0.8, centroZ+40, 0.3, 0.3, 0.3);
    //Peito
    desenhaParalelepipedo(centroX, centroY, centroZ+40, 1, 1.6, 0.6);
    //Brao Direito
    desenhaParalelepipedo(centroX+0.5, centroY+0.6, centroZ+40, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX+0.7, centroY+0.2, centroZ+40, 0.2, 1, 0.2);
    //Brao Esquerdo
    desenhaParalelepipedo(centroX-0.5, centroY+0.6, centroZ+40, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX-0.7, centroY+0.2, centroZ+40, 0.2, 1, 0.2);
    //Perna Direita
    desenhaParalelepipedo(centroX-0.3, centroY-1.2, centroZ+40, 0.4,0.8, 0.4);
    //Perna Esquerda
    desenhaParalelepipedo(centroX+0.3, centroY-1.2, centroZ+40, 0.4, 0.8, 0.4);

    // Boneco 4 Time 1
    // Cabeca
    glColor3f ( 1, 1, 0);
    desenhaParalelepipedo(centroX-5, centroY+1.2, centroZ, 0.6, 0.6, 0.6);
    //Pescoo
    desenhaParalelepipedo(centroX-5, centroY+0.8, centroZ, 0.3, 0.3, 0.3);
    //Peito
    desenhaParalelepipedo(centroX-5, centroY, centroZ, 1, 1.6, 0.6);
    //Brao Direito
    desenhaParalelepipedo(centroX+0.5-5, centroY+0.6, centroZ, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX+0.7-5, centroY+0.2, centroZ, 0.2, 1, 0.2);
    //Brao Esquerdo
    desenhaParalelepipedo(centroX-0.5-5, centroY+0.6, centroZ, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX-0.7-5, centroY+0.2, centroZ, 0.2, 1, 0.2);
    //Perna Direita
    desenhaParalelepipedo(centroX-0.3-5, centroY-1.2, centroZ, 0.4,0.8, 0.4);
    //Perna Esquerda
    desenhaParalelepipedo(centroX+0.3-5, centroY-1.2, centroZ, 0.4, 0.8, 0.4);

    // Boneco 5 Time 1
      glColor3f ( 1, 1, 0);
    // Cabeca
    desenhaParalelepipedo(centroX-10, centroY+1.2, centroZ+20, 0.6, 0.6, 0.6);
    //Pescoo
    desenhaParalelepipedo(centroX-10, centroY+0.8, centroZ+20, 0.3, 0.3, 0.3);
    //Peito
    desenhaParalelepipedo(centroX-10, centroY, centroZ+20, 1, 1.6, 0.6);
    //Brao Direito
    desenhaParalelepipedo(centroX+0.5-10, centroY+0.6, centroZ+20, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX+0.7-10, centroY+0.2, centroZ+20, 0.2, 1, 0.2);
    //Brao Esquerdo
    desenhaParalelepipedo(centroX-0.5-10, centroY+0.6, centroZ+20, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX-0.7-10, centroY+0.2, centroZ+20, 0.2, 1, 0.2);
    //Perna Direita
    desenhaParalelepipedo(centroX-0.3-10, centroY-1.2, centroZ+20, 0.4,0.8, 0.4);
    //Perna Esquerda
    desenhaParalelepipedo(centroX+0.3-10, centroY-1.2, centroZ+20, 0.4, 0.8, 0.4);


    // Boneco 1 Time 2
    glColor3f ( 0, 0, 1);
    // Cabeca
    desenhaParalelepipedo(centroX, centroY+1.2, centroZ+18, 0.6, 0.6, 0.6);
    //Pescoo
    desenhaParalelepipedo(centroX, centroY+0.8, centroZ+18, 0.3, 0.3, 0.3);
    //Peito
    desenhaParalelepipedo(centroX, centroY, centroZ+18, 1, 1.6, 0.6);
    //Brao Direito
    desenhaParalelepipedo(centroX+0.5, centroY+0.6, centroZ+18, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX+0.7, centroY+0.2, centroZ+18, 0.2, 1, 0.2);
    //Brao Esquerdo
    desenhaParalelepipedo(centroX-0.5, centroY+0.6, centroZ+18, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX-0.7, centroY+0.2, centroZ+18, 0.2, 1, 0.2);
    //Perna Direita
    desenhaParalelepipedo(centroX-0.3, centroY-1.2, centroZ+18, 0.4,0.8, 0.4);
    //Perna Esquerda
    desenhaParalelepipedo(centroX+0.3, centroY-1.2, centroZ+18, 0.4, 0.8, 0.4);

    // Boneco 2 Time 2
      glColor3f ( 0, 0, 1);
    // Cabeca
    desenhaParalelepipedo(centroX+10, centroY+1.2, centroZ+10, 0.6, 0.6, 0.6);
    //Pescoo
    desenhaParalelepipedo(centroX+10, centroY+0.8, centroZ+10, 0.3, 0.3, 0.3);
    //Peito
    desenhaParalelepipedo(centroX+10, centroY, centroZ+10, 1, 1.6, 0.6);
    //Brao Direito
    desenhaParalelepipedo(centroX+0.5+10, centroY+0.6, centroZ+10, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX+0.7+10, centroY+0.2, centroZ+10, 0.2, 1, 0.2);
    //Brao Esquerdo
    desenhaParalelepipedo(centroX-0.5+10, centroY+0.6, centroZ+10, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX-0.7+10, centroY+0.2, centroZ+10, 0.2, 1, 0.2);
    //Perna Direita
    desenhaParalelepipedo(centroX-0.3+10, centroY-1.2, centroZ+10, 0.4,0.8, 0.4);
    //Perna Esquerda
    desenhaParalelepipedo(centroX+0.3+10, centroY-1.2, centroZ+10, 0.4, 0.8, 0.4);

    // Boneco 3 Time 2
     glColor3f ( 1, 1, 0);
    // Cabeca
    desenhaParalelepipedo(centroX, centroY+1.2, centroZ-40, 0.6, 0.6, 0.6);
    //Pescoo
    desenhaParalelepipedo(centroX, centroY+0.8, centroZ-40, 0.3, 0.3, 0.3);
    //Peito
    desenhaParalelepipedo(centroX, centroY, centroZ-40, 1, 1.6, 0.6);
    //Brao Direito
    desenhaParalelepipedo(centroX+0.5, centroY+0.6, centroZ-40, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX+0.7, centroY+0.2, centroZ-40, 0.2, 1, 0.2);
    //Brao Esquerdo
    desenhaParalelepipedo(centroX-0.5, centroY+0.6, centroZ-40, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX-0.7, centroY+0.2, centroZ-40, 0.2, 1, 0.2);
    //Perna Direita
    desenhaParalelepipedo(centroX-0.3, centroY-1.2, centroZ-40, 0.4,0.8, 0.4);
    //Perna Esquerda
    desenhaParalelepipedo(centroX+0.3, centroY-1.2, centroZ-40, 0.4, 0.8, 0.4);

    // Boneco 4 Time 2
    // Cabeca
    glColor3f ( 0, 0, 1);
    desenhaParalelepipedo(centroX-5, centroY+1.2, centroZ+15, 0.6, 0.6, 0.6);
    //Pescoo
    desenhaParalelepipedo(centroX-5, centroY+0.8, centroZ+15, 0.3, 0.3, 0.3);
    //Peito
    desenhaParalelepipedo(centroX-5, centroY, centroZ+15, 1, 1.6, 0.6);
    //Brao Direito
    desenhaParalelepipedo(centroX+0.5-5, centroY+0.6, centroZ+15, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX+0.7-5, centroY+0.2, centroZ+15, 0.2, 1, 0.2);
    //Brao Esquerdo
    desenhaParalelepipedo(centroX-0.5-5, centroY+0.6, centroZ+15, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX-0.7-5, centroY+0.2, centroZ+15, 0.2, 1, 0.2);
    //Perna Direita
    desenhaParalelepipedo(centroX-0.3-5, centroY-1.2, centroZ+15, 0.4,0.8, 0.4);
    //Perna Esquerda
    desenhaParalelepipedo(centroX+0.3-5, centroY-1.2, centroZ+15, 0.4, 0.8, 0.4);

    // Boneco 5 Time 2
      glColor3f ( 0, 0, 1);
    // Cabeca
    desenhaParalelepipedo(centroX+20, centroY+1.2, centroZ+10, 0.6, 0.6, 0.6);
    //Pescoo
    desenhaParalelepipedo(centroX+20, centroY+0.8, centroZ+10, 0.3, 0.3, 0.3);
    //Peito
    desenhaParalelepipedo(centroX+20, centroY, centroZ+10, 1, 1.6, 0.6);
    //Brao Direito
    desenhaParalelepipedo(centroX+0.5+20, centroY+0.6, centroZ+10, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX+0.7+20, centroY+0.2, centroZ+10, 0.2, 1, 0.2);
    //Brao Esquerdo
    desenhaParalelepipedo(centroX-0.5+20, centroY+0.6, centroZ+10, 0.2, 0.2, 0.2);
    desenhaParalelepipedo(centroX-0.7+20, centroY+0.2, centroZ+10, 0.2, 1, 0.2);
    //Perna Direita
    desenhaParalelepipedo(centroX-0.3+20, centroY-1.2, centroZ+10, 0.4,0.8, 0.4);
    //Perna Esquerda
    desenhaParalelepipedo(centroX+0.3+20, centroY-1.2, centroZ+10, 0.4, 0.8, 0.4);



  glEnd( );
  glLoadIdentity();
};

/* ============ Variveis Globais ============ */
int JanelaPrincipal;
int Altura, Largura;
//float rTri = 0;
int rot = 0;
int rotz = 0;
int rotx = 0;
float posX = 0;
float posY = 0;
float posZ = 0;
PESSOA joao;

/* ============ Prottipos das funes ============ */
int inicializaGL(GLvoid);     // inicializao openGL
void desenhaMundo(GLvoid);    // desenha os objetos
void mostraMundo(void);       // quando estiver ocioso mostre o mundo
void desenhaJanela(int largura, int altura);            // confiraes para a janela
void teclasComuns(unsigned char tecla, int x, int y);   // manipula aes com teclas
void teclasEspeciais(int tecla, int x, int y);          // manipula aes com teclas

/* ============ Funo de Inicializao do Sistema ============ */
int inicializaGL(GLvoid)
{
  glShadeModel(GL_SMOOTH);                  // Tipo de Sombreamento Suavizado
  glClearColor( 0.0f, 0.0f, 0.0f, 0.0f);    // Cor de Limpeza de tela

  // no Entendi
  glClearDepth( 1.0f );                 // Inicializao do Buffer de Profundidade
  glEnable(GL_DEPTH_TEST );             // Habilita tipo de Teste para o Buffer
  glDepthFunc(GL_LEQUAL);               // Define tipo de Teste de Profundidade
  // =================

  glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST );  // Tipo de Pespectiva
  return TRUE;
}

/* ============ Funo de desenho dos objetos ============ */
void desenhaMundo(GLvoid)
{
  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);  // Limpa a tela e o Buffer
  glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);      // Desenhar os dois lados de um objeto
  glLoadIdentity();                                     // Resete a Matriz de Modelos de Projeo
  //======================= Cdigo dos objetos deve ser inserido aqui =======================

  // Construir um Cubo
  glLoadIdentity();
  glRotatef(-rot, 0, 1, 0);
  glRotatef(-rotx,sin(((rot*(2*M_PI))/360)), 0,cos(((rot*(2*M_PI))/360)));
  glRotatef(-rotz,cos(((rot*(2*M_PI))/360)), 0,-sin(((rot*(2*M_PI))/360)));

  glTranslatef( -posX , -posY, -posZ);


  joao.mostraPessoa();

  //=========================================================================================
  glutSwapBuffers();    // Troca os buffers de desenho e de exibio
}

/* ============ Funo que ser ativada sempre que o sistema estiver ocioso ============ */
void mostraMundo(void)
{
  desenhaMundo();
}

/* ============ Funo de redesenho da Janela ============ */
void desenhaJanela(int largura, int altura)
{
  Altura = altura;
  Largura = largura;

  if ( ! altura )
    altura = 1;

  glViewport(0, 0, largura, altura);    // Determina as coordenadas da ViewPort
  glMatrixMode(GL_PROJECTION);          // Seta proxima operacao para a pilha de projees
  glLoadIdentity();                     // Resete a Matriz de Projeo

  // No entendi
  //====================
  gluPerspective(60, (GLfloat)largura/(GLfloat)altura, 1, 500);
  //=====================

  glMatrixMode(GL_MODELVIEW);           // Seta proxima operacao para a pilha de Modelos
  glLoadIdentity();                     // Resete a Matriz de Modelos de Projeo
}

/* ============ Funo de controle de teclas comuns ============ */
void teclasComuns(unsigned char tecla, int x, int y)
{
float rad;
  switch ( tecla )
  {
    case ESC:
      glutDestroyWindow( JanelaPrincipal );
      exit(0);
    break;
    case 'w' :
       posY+= 1;
    break;
    case 's' :
       posY-= 1;
    break;
    case 'a' :
         rad = (((2*M_PI)*rot)/360)+(M_PI/2);
         posX -= sin( rad );
         posZ -= cos( rad );
    break;
    case 'd' :
         rad = (((2*M_PI)*rot)/360)+(M_PI/2);
         posX += sin( rad );
         posZ += cos( rad );
    break;
    case 'q' :
         rotx += 15;

    break;
    case 'e' :
         rotx -= 15;
    break;
    case 'z' :
         rotz += 15;

    break;
    case 'x' :
         rotz -= 15;
    break;
  }
}

/* ============ Funo de controle de teclas Especiais ============ */
void teclasEspeciais(int tecla, int x, int y)
{
float rad;
if(rot>360){
  rot-= 360;
}else if(rot < -360){
   rot += 360;
}
  switch( tecla )
  {
    case GLUT_KEY_F11:
      glutFullScreen();
    break;
    case GLUT_KEY_F12:
        glutPositionWindow(200, 200);
        glutReshapeWindow(500, 400);
    break;
    case GLUT_KEY_RIGHT:
      rot -= 5;
    break;
    case GLUT_KEY_LEFT:
      rot += 5;
    break;
    case GLUT_KEY_UP:
         rad = (((2*M_PI)*rot)/360);
         posX -= sin( rad );
         posZ -= cos( rad );
    break;
    case GLUT_KEY_DOWN:
         rad = (((2*M_PI)*rot)/360);
         posX += sin( rad );
         posZ += cos( rad );
    break;
  }
}

/* ============ Funo Principal do Sistema ============ */
int main(int argc, char* argv[])
{
 // glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
  glutInitWindowPosition(200, 200);
  glutInitWindowSize(500, 400);
  JanelaPrincipal = glutCreateWindow("Computao Grfica - OpenGL - Trabalho Final");
  glutReshapeFunc( desenhaJanela );
  glutDisplayFunc( desenhaMundo );
  glutKeyboardFunc( teclasComuns );
  glutSpecialFunc( teclasEspeciais );
  glutIdleFunc( mostraMundo );
  inicializaGL();
  glutFullScreen();
  glutMainLoop();
  return 0;
}

